/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils;

import com.silabs.java.utils.Result;
import com.silabs.java.utils.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;

public class SdkSemanticVersion
implements Comparable<SdkSemanticVersion> {
    private final String primaryVersion;
    private final String prerelease;
    private final String build;
    private static final SdkSemanticVersion UNVERSIONED = new SdkSemanticVersion("0.0.0", null, null);
    private static final char PART_SPLITTER = '.';
    private static final char PRERELEASE_SPLITTER = '-';
    private static final char BUILD_SPLITTER = '+';
    private static final Pattern ALPHANUMERIC = Pattern.compile("[A-Za-z0-9]+");
    private static final String ERROR_NOT_START_PERIOD = "version identifiers cannot start with a period";

    private SdkSemanticVersion(String primaryVersion, String pre, String build) {
        this.primaryVersion = primaryVersion;
        this.prerelease = pre;
        this.build = build;
    }

    public static SdkSemanticVersion create(String raw) {
        Result<SdkSemanticVersion, String> result = SdkSemanticVersion.createIf(raw);
        if (result.isOK()) {
            return result.okValue();
        }
        throw new IllegalArgumentException(result.error());
    }

    public static Result<SdkSemanticVersion, String> createIf(String raw) {
        List<String> parts;
        if ("0.0.0".equals(raw)) {
            return Result.ok(UNVERSIONED);
        }
        List<String> splitByPre = TextUtils.splitByCharacterToList(raw, '-');
        if (splitByPre.size() > 2) {
            return SdkSemanticVersion.makeError(raw, "Only one '-' may appear, and it must appear instead of the period for the last version segment and be followed by other version-style segment");
        }
        String primary = null;
        String prerelease = null;
        String build = null;
        if (splitByPre.size() == 1) {
            String possiblePrimary = splitByPre.get(0);
            parts = TextUtils.splitByCharacterToList(possiblePrimary, '+');
            if (parts.size() == 1 || TextUtils.isEmpty(possiblePrimary)) {
                primary = possiblePrimary;
            } else if (parts.size() == 2) {
                primary = parts.get(0);
                build = parts.get(1);
            }
        } else if (splitByPre.size() == 2) {
            primary = splitByPre.get(0);
            if (primary.contains("+")) {
                return SdkSemanticVersion.makeError(raw, "Only one '+' may appear, and it must appear towards the end");
            }
            String secondary = splitByPre.get(1);
            parts = TextUtils.splitByCharacterToList(secondary, '+');
            if (parts.size() == 1 || TextUtils.isEmpty(secondary)) {
                prerelease = secondary;
            } else {
                prerelease = parts.get(0);
                build = parts.get(1);
            }
        }
        assert (primary != null) : "No matter which flow was used, primary version must have been set by now or returned an error if unavailable.";
        if (primary.startsWith(".") || prerelease != null && prerelease.startsWith(".") || build != null && build.startsWith(".")) {
            return SdkSemanticVersion.makeError(raw, ERROR_NOT_START_PERIOD);
        }
        if ("".equals(prerelease) || "".equals(build)) {
            return SdkSemanticVersion.makeError(raw, "A subdivided '-' or '+' section contained no data");
        }
        List<String> primaryPartitions = TextUtils.splitByCharacterToList(primary, '.');
        if (primaryPartitions.size() != 3) {
            return SdkSemanticVersion.makeError(raw, "must have at least majour.minor.patch versions");
        }
        parts = new ArrayList<String>();
        parts.addAll(primaryPartitions);
        parts.addAll(SdkSemanticVersion.partSplit(prerelease));
        parts.addAll(SdkSemanticVersion.partSplit(build));
        for (String part : parts) {
            if ("".equals(part)) {
                return SdkSemanticVersion.makeError(raw, "Missing alphanumeric specifier after period");
            }
            if (part.length() > 1 && part.startsWith("0")) {
                return SdkSemanticVersion.makeError(raw, "cannot have leading zeros for any version part");
            }
            if (ALPHANUMERIC.matcher(part).matches()) continue;
            return Result.err("Invalid Sdk Semantic Version: '" + part + "' is not alphanumeric");
        }
        return Result.ok(new SdkSemanticVersion(primary, prerelease, build));
    }

    public static SdkSemanticVersion unversioned() {
        return UNVERSIONED;
    }

    private static List<String> partSplit(String part) {
        if (part == null) {
            return Collections.emptyList();
        }
        return TextUtils.splitByCharacterToList(part, '.');
    }

    private static Result<SdkSemanticVersion, String> makeError(String badVersion, String post) {
        return Result.err("Version '" + badVersion + "' " + post);
    }

    public String fullVersion() {
        return this.primaryVersion + SdkSemanticVersion.emptyIfNull(this.prerelease, "-") + SdkSemanticVersion.emptyIfNull(this.build, "+");
    }

    public String primaryVersion() {
        return this.primaryVersion;
    }

    public Optional<String> prerelease() {
        return Optional.ofNullable(this.prerelease);
    }

    public Optional<String> build() {
        return Optional.ofNullable(this.build);
    }

    private static String emptyIfNull(String part, String prefix) {
        return part == null ? "" : prefix + part;
    }

    @Override
    public int compareTo(SdkSemanticVersion o) {
        List<String> ourVersions = TextUtils.splitByCharacterToList(this.primaryVersion, '.');
        List<String> theirVersions = TextUtils.splitByCharacterToList(o.primaryVersion, '.');
        assert (ourVersions.size() == 3 && theirVersions.size() == 3) : "Version objects created without exactly majour/minor/patch parts: " + ourVersions + " - " + theirVersions;
        int intermediateResult = SdkSemanticVersion.partComparison(ourVersions, theirVersions);
        if (intermediateResult != 0) {
            return intermediateResult;
        }
        if (this.prerelease != null && o.prerelease != null) {
            List<String> ourPrerelease = TextUtils.splitByCharacterToList(this.prerelease, '.');
            List<String> theirPrerelease = TextUtils.splitByCharacterToList(o.prerelease, '.');
            return SdkSemanticVersion.partComparison(ourPrerelease, theirPrerelease);
        }
        if (this.prerelease == null && o.prerelease != null) {
            return 1;
        }
        if (o.prerelease == null && this.prerelease != null) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SdkSemanticVersion)) {
            return false;
        }
        SdkSemanticVersion other = (SdkSemanticVersion)o;
        return Objects.equals(this.primaryVersion, other.primaryVersion) && Objects.equals(this.prerelease, other.prerelease);
    }

    public int hashCode() {
        return Objects.hash(this.primaryVersion, this.prerelease);
    }

    public String toString() {
        return this.fullVersion();
    }

    private static int partComparison(List<String> ourVersions, List<String> theirVersions) {
        for (int i = 0; i < Math.min(ourVersions.size(), theirVersions.size()); ++i) {
            Integer theirInt;
            Integer ourInt;
            String their;
            String our = ourVersions.get(i);
            int result = SdkSemanticVersion.comparePart(our, their = theirVersions.get(i), ourInt = SdkSemanticVersion.intOrNull(our), theirInt = SdkSemanticVersion.intOrNull(their));
            if (result == 0) continue;
            return result;
        }
        return ourVersions.size() - theirVersions.size();
    }

    private static int comparePart(String our, String their, Integer ourInt, Integer theirInt) {
        if (ourInt != null && theirInt != null) {
            return ourInt.compareTo(theirInt);
        }
        if (ourInt == null && theirInt == null) {
            return our.compareTo(their);
        }
        if (ourInt != null) {
            return -1;
        }
        return 1;
    }

    private static Integer intOrNull(String who) {
        try {
            return Integer.parseInt(who);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

