/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils.extension;

import com.silabs.java.utils.ITypedFilter;
import com.silabs.java.utils.extension.IExtensionInformation;

public abstract class BasePluginFilter
implements ITypedFilter<IExtensionInformation> {
    protected final boolean allowTestPlugins;
    protected final boolean requireTestPlugins;

    public BasePluginFilter() {
        this(false, false);
    }

    public BasePluginFilter(boolean allowTestPlugins, boolean requireTestPlugins) {
        this.allowTestPlugins = allowTestPlugins;
        this.requireTestPlugins = requireTestPlugins;
    }

    @Override
    public boolean accept(IExtensionInformation object) {
        if (this.allowTestPlugins && !this.requireTestPlugins) {
            return true;
        }
        String id = object.getNamespaceIdentifier();
        boolean isFromTestPlugin = this.isTestPluginId(id);
        return isFromTestPlugin == this.allowTestPlugins && (!this.requireTestPlugins || isFromTestPlugin);
    }

    protected boolean isTestPluginId(String id) {
        return id.contains(".tests.") || id.contains(".test.") || id.endsWith(".tests") || id.endsWith(".test");
    }
}

