/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils.log;

import com.silabs.java.utils.log.IStatusLineHandler;
import java.util.ArrayList;
import java.util.List;

public class StatusLineHandlerManager {
    private final List<IStatusLineHandler> statusLines = new ArrayList<IStatusLineHandler>();

    public void clearErrorMessage() {
        for (IStatusLineHandler slm : this.statusLines) {
            slm.setErrorMessage(null);
        }
    }

    public void statusLine(String message, boolean isError) {
        for (IStatusLineHandler slm : this.statusLines) {
            if (isError) {
                slm.setErrorMessage(message);
                continue;
            }
            slm.setErrorMessage(null);
            slm.setMessage(message);
        }
    }

    public void addStatusLineManager(IStatusLineHandler slm) {
        if (!this.statusLines.contains(slm)) {
            this.statusLines.add(slm);
        }
    }

    public void removeStatusLineManager(IStatusLineHandler slm) {
        this.statusLines.remove(slm);
    }
}

