/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils.variables.engine;

import com.silabs.java.utils.TextUtils;
import com.silabs.java.utils.log.Log;
import com.silabs.java.utils.runtime.RuntimeUtils;
import com.silabs.java.utils.variables.engine.IOperation;
import com.silabs.java.utils.variables.engine.IOperatorHandler;
import com.silabs.java.utils.variables.engine.OperationUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CoreOperatorHandler
implements IOperatorHandler {
    public static CoreOperatorHandler INSTANCE = new CoreOperatorHandler(null, ":");
    public static final String DEFAULT = "default";
    public static final String TO_UPPER = "toUpper";
    public static final String TO_LOWER = "toLower";
    public static final String TO_TITLE = "toTitle";
    public static final String TO_TITLE_LOWER = "toTitleLower";
    public static final String TO_IDENTIFIER = "toIdentifier";
    public static final String TO_C_HEX = "toCHex";
    public static final String TO_C_STRING = "toCString";
    public static final String IF_DEV_MODE = "ifDevMode";
    public static final String IF_ELSE = "ifElse";
    public static final String STRIP_END_CHARS = "stripEndChars";
    private static Map<String, IOperation> operators = new ConcurrentHashMap<String, IOperation>();
    protected String sep;
    protected IOperatorHandler parent;

    public static void registerConversionOperator(String suffix, IOperation op) {
        operators.put(suffix, op);
    }

    public CoreOperatorHandler(IOperatorHandler parent, String sep) {
        this.parent = parent;
        this.sep = sep;
    }

    protected static void assertNotNull(Object value) throws IOperation.OperationException {
        OperationUtils.assertNotNull(value);
    }

    protected static void assertParameters(String[] operationParameters, int expParamCount) throws IOperation.OperationException {
        OperationUtils.assertParameters(operationParameters, expParamCount);
    }

    @Override
    public String[] splitVariableAndOperations(String varWithOperations) {
        int idx;
        int questIdx = varWithOperations.indexOf(63);
        if (questIdx > 0 && varWithOperations.indexOf(58, questIdx) > 0) {
            String lhs;
            int colIdx;
            String var = varWithOperations.substring(0, questIdx);
            int parenCount = 0;
            for (colIdx = questIdx + 1; colIdx < varWithOperations.length(); ++colIdx) {
                char ch = varWithOperations.charAt(colIdx);
                if (ch == '(') {
                    ++parenCount;
                    continue;
                }
                if (ch == ')') {
                    --parenCount;
                    continue;
                }
                if (parenCount == 0 && ch == ':') break;
            }
            if ((lhs = varWithOperations.substring(questIdx + 1, colIdx)).startsWith("(") && lhs.endsWith(")")) {
                lhs = lhs.substring(1, lhs.length() - 1);
            }
            String rhs = colIdx < varWithOperations.length() ? varWithOperations.substring(colIdx + 1) : "";
            return this.splitVariableAndOperations(var + ":ifElse(" + lhs + "," + rhs + ")");
        }
        int colIdx = varWithOperations.indexOf(this.sep);
        if (colIdx < 0) {
            return new String[]{varWithOperations};
        }
        ArrayList<String> parts = new ArrayList<String>(2);
        int prevIdx = 0;
        int paren = 0;
        for (idx = colIdx; idx < varWithOperations.length(); ++idx) {
            if (varWithOperations.charAt(idx) == '(') {
                ++paren;
                continue;
            }
            if (varWithOperations.charAt(idx) == ')' && paren > 0) {
                --paren;
                continue;
            }
            if (paren != 0 || !varWithOperations.startsWith(this.sep, idx)) continue;
            if (prevIdx < idx) {
                parts.add(varWithOperations.substring(prevIdx, idx));
            }
            prevIdx = idx + this.sep.length();
        }
        if (prevIdx + 1 < idx) {
            parts.add(varWithOperations.substring(prevIdx, idx));
        }
        return parts.toArray(new String[parts.size()]);
    }

    @Override
    public Object operate(String operationString, Object object) throws IOperation.OperationException {
        IOperation op;
        String operation = operationString;
        String[] operationParameters = null;
        int idx = operationString.indexOf(40);
        if (idx > 0) {
            operation = operationString.substring(0, idx);
            String opParStr = operationString.substring(idx + 1);
            if (!opParStr.endsWith(")")) {
                throw IOperation.OperationException.newOperationError("invalid operation syntax: expected parentheses around parameters: '" + opParStr);
            }
            opParStr = opParStr.substring(0, opParStr.length() - 1);
            operationParameters = opParStr.split(",");
        }
        if ((op = operators.get(operation)) != null) {
            String converted = op.operate(operation, operationParameters, object);
            return converted;
        }
        throw IOperation.OperationException.newOperationError(MessageFormat.format("unhandled operation; supported operations:\n\t{0}", TextUtils.catenateStrings(operators.keySet(), ", ")));
    }

    static {
        CoreOperatorHandler.registerConversionOperator(DEFAULT, new IOperation(){

            @Override
            public String operate(String operation, String[] operationParameters, Object value) throws IOperation.OperationException {
                CoreOperatorHandler.assertParameters(operationParameters, 1);
                if (value != null) {
                    return value.toString();
                }
                return operationParameters[0];
            }
        });
        CoreOperatorHandler.registerConversionOperator(TO_UPPER, new IOperation(){

            @Override
            public String operate(String operation, String[] operationParameters, Object value) throws IOperation.OperationException {
                CoreOperatorHandler.assertParameters(operationParameters, -1);
                CoreOperatorHandler.assertNotNull(value);
                return value.toString().toUpperCase(Locale.ROOT);
            }
        });
        CoreOperatorHandler.registerConversionOperator(TO_LOWER, new IOperation(){

            @Override
            public String operate(String operation, String[] operationParameters, Object value) throws IOperation.OperationException {
                CoreOperatorHandler.assertParameters(operationParameters, -1);
                CoreOperatorHandler.assertNotNull(value);
                return value.toString().toLowerCase(Locale.ROOT);
            }
        });
        CoreOperatorHandler.registerConversionOperator(TO_TITLE, new IOperation(){

            @Override
            public String operate(String operation, String[] operationParameters, Object value) throws IOperation.OperationException {
                CoreOperatorHandler.assertParameters(operationParameters, -1);
                CoreOperatorHandler.assertNotNull(value);
                String string = value.toString();
                if (string.isEmpty()) {
                    return string;
                }
                char c = Character.toUpperCase(string.charAt(0));
                return c + string.substring(1);
            }
        });
        CoreOperatorHandler.registerConversionOperator(TO_TITLE_LOWER, new IOperation(){

            @Override
            public String operate(String operation, String[] operationParameters, Object value) throws IOperation.OperationException {
                CoreOperatorHandler.assertParameters(operationParameters, -1);
                CoreOperatorHandler.assertNotNull(value);
                return TextUtils.titleCase(value.toString().toLowerCase(Locale.ROOT));
            }
        });
        CoreOperatorHandler.registerConversionOperator(TO_IDENTIFIER, new IOperation(){

            @Override
            public String operate(String operation, String[] operationParameters, Object value) throws IOperation.OperationException {
                CoreOperatorHandler.assertParameters(operationParameters, -1);
                CoreOperatorHandler.assertNotNull(value);
                Object id = value.toString();
                if (((String)id).length() == 0) {
                    return "_";
                }
                if (!Character.isJavaIdentifierStart(((String)id).charAt(0))) {
                    id = "_" + (String)id;
                }
                char[] idc = ((String)id).toCharArray();
                for (int i = 0; i < idc.length; ++i) {
                    if (Character.isJavaIdentifierPart(idc[i])) continue;
                    idc[i] = 95;
                }
                return new String(idc);
            }
        });
        CoreOperatorHandler.registerConversionOperator(TO_C_HEX, new IOperation(){

            @Override
            public String operate(String operation, String[] operationParameters, Object value) throws IOperation.OperationException {
                CoreOperatorHandler.assertParameters(operationParameters, -1);
                CoreOperatorHandler.assertNotNull(value);
                if (!(value instanceof Number)) {
                    value = Long.parseLong(value.toString());
                }
                return "0x" + Long.toHexString(((Number)value).longValue());
            }
        });
        CoreOperatorHandler.registerConversionOperator(TO_C_STRING, new IOperation(){

            @Override
            public String operate(String operation, String[] operationParameters, Object value) throws IOperation.OperationException {
                CoreOperatorHandler.assertParameters(operationParameters, -1);
                CoreOperatorHandler.assertNotNull(value);
                String val = value.toString();
                return TextUtils.quote(val, '\"');
            }
        });
        CoreOperatorHandler.registerConversionOperator(IF_DEV_MODE, new IOperation(){

            @Override
            public String operate(String operation, String[] operationParameters, Object value) throws IOperation.OperationException {
                CoreOperatorHandler.assertParameters(operationParameters, 1);
                CoreOperatorHandler.assertNotNull(value);
                String val = value.toString();
                if (RuntimeUtils.isPlatformPDELaunch()) {
                    val = operationParameters[0];
                }
                return val;
            }
        });
        CoreOperatorHandler.registerConversionOperator(IF_ELSE, new IOperation(){

            @Override
            public String operate(String operation, String[] operationParameters, Object value) throws IOperation.OperationException {
                CoreOperatorHandler.assertParameters(operationParameters, 2);
                CoreOperatorHandler.assertNotNull(value);
                String val = value.toString();
                val = "true".equalsIgnoreCase(val) ? operationParameters[0] : operationParameters[1];
                return val;
            }
        });
        CoreOperatorHandler.registerConversionOperator(STRIP_END_CHARS, new IOperation(){

            @Override
            public String operate(String operation, String[] operationParameters, Object value) throws IOperation.OperationException {
                CoreOperatorHandler.assertParameters(operationParameters, 1);
                CoreOperatorHandler.assertNotNull(value);
                String val = value.toString();
                int chars = 0;
                try {
                    chars = Integer.parseInt(operationParameters[0]);
                }
                catch (NumberFormatException e) {
                    Log.error(e);
                }
                return val.substring(0, val.length() - chars);
            }
        });
    }
}

