/*
 * Decompiled with CFR 0.152.
 */
package slc.launcher;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import slc.launcher.BaseSlcLauncher;
import slc.launcher.ISlcLauncher;
import slc.launcher.context.SlcCliContext;
import slc.launcher.instrumented.JavaLauncherTelemetryUtils;
import slc.launcher.utils.ExecutionUtils;
import slc.launcher.utils.ISlcExitCode;
import slc.launcher.utils.SlcExitCodes;

public class SlcDirectLauncher
extends BaseSlcLauncher
implements ISlcLauncher {
    public SlcDirectLauncher(SlcCliContext context) {
        super(context);
    }

    @Override
    public ISlcExitCode launch() {
        List<String> args2 = super.launchArgs();
        args2.add("-Dslc_consolecolour=" + this.slcArgs.isColor);
        JavaLauncherTelemetryUtils.injectContextInArgs(args2);
        int width = this.terminalWidth();
        if (width != -1) {
            args2.add("-Dslc_consolewidth=" + width);
        }
        try {
            ISlcExitCode exitCode = ExecutionUtils.launchSlcProcess((SlcCliContext)this.context, (boolean)false, (boolean)false, args2).exitCode;
            this.context.debugPrint("SLC Tool returned status code " + exitCode);
            return exitCode;
        }
        catch (FileNotFoundException e) {
            this.context.printErr(args2.get(0) + " not found -- command line cannot run.");
            return SlcExitCodes.MISSING_SLC_BINARY;
        }
        catch (IOException e) {
            this.context.printErr("SLC process failed. See error log for more information.", e);
            return SlcExitCodes.GENERAL_ERROR;
        }
    }
}

