/*
 * Decompiled with CFR 0.152.
 */
package slc.launcher.connection;

import com.silabs.java.utils.TextUtils;
import com.silabs.uc.cli.internal.daemon.shared.SlcDaemonSharedData;
import java.net.URI;
import java.net.http.WebSocket;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONException;
import org.json.JSONObject;
import slc.launcher.connection.ConnectionUtils;
import slc.launcher.connection.SlcRestRequest;
import slc.launcher.context.SlcCliContext;
import slc.launcher.context.SlcTimer;
import slc.launcher.utils.CustomSlcExitCode;
import slc.launcher.utils.ISlcExitCode;
import slc.launcher.utils.SlcExitCodes;

public final class SocketCommunicationThread {
    private static final String UUID_MESSAGE = "websocket_context";
    private static final String STDOUT = "out";
    private static final String STDERR = "err";
    private static final String UUID_DONE = "done";
    private static final String RETURN_CODE = "return_code";
    private static final String SHUTDOWN_CODE = "server_termination";
    private final SlcCliContext context;
    private final SlcDaemonSharedData sharedFile;
    private final String uuid;
    private final JSONObject slcPayload;
    private final SocketCommsListener commsListener;
    private final ISlcExitCode DEFAULT_RESULT = SlcExitCodes.UNKNOWN_DAEMON_CODE;
    private final AtomicReference<ISlcExitCode> result = new AtomicReference<ISlcExitCode>(this.DEFAULT_RESULT);
    private CountDownLatch completionLatch = new CountDownLatch(1);

    public SocketCommunicationThread(SlcCliContext context, SlcDaemonSharedData sharedFile, String uuid, JSONObject slcPayload) {
        this.context = context;
        this.sharedFile = sharedFile;
        this.uuid = uuid;
        this.slcPayload = slcPayload;
        this.commsListener = new SocketCommsListener();
    }

    public ISlcExitCode getResult() {
        return this.result.get();
    }

    public boolean run() {
        WebSocket webSocket;
        URI uri = ConnectionUtils.wsFeedback(this.sharedFile);
        this.context.debugPrint("Awaiting socket connection at " + uri);
        SlcTimer timer = this.context.timer("Creating Socket Connection");
        try {
            CompletableFuture<WebSocket> awaitTheSocket = ConnectionUtils.httpclient().newWebSocketBuilder().buildAsync(uri, this.commsListener);
            webSocket = awaitTheSocket.get(this.context.args().socketTimeout, TimeUnit.SECONDS);
        }
        catch (ExecutionException | TimeoutException e) {
            if (this.context.args().debug) {
                this.context.printErr("Websocket connection failed: " + e.getMessage(), e);
            }
            return false;
        }
        catch (InterruptedException e) {
            if (this.context.args().debug) {
                this.context.printErr("Websocket connection thread interrupted: " + e.getMessage(), e);
            }
            return false;
        }
        this.context.debugPrint("Socket Connected at " + uri);
        timer.done();
        SlcRestRequest.run(this.context, this.sharedFile, this.slcPayload);
        timer = this.context.timer("Socket Connection Live");
        try {
            this.completionLatch.await();
        }
        catch (InterruptedException e) {
            this.context.print("Connection interrupted. Exiting.");
            this.result.compareAndSet(this.DEFAULT_RESULT, SlcExitCodes.COMMAND_INTERRUPTED);
        }
        timer.done();
        timer = this.context.timer("Socket Connection Shutdown");
        webSocket.sendClose(1000, "Command Complete");
        timer.done();
        return true;
    }

    private void processMessage(WebSocket webSocket, StringBuilder messageStr) {
        if (messageStr.isEmpty()) {
            return;
        }
        try {
            JSONObject msg = new JSONObject(messageStr.toString());
            if (this.asString(msg, UUID_MESSAGE).equals(this.uuid)) {
                String output = this.asString(msg, STDOUT);
                String error = this.asString(msg, STDERR);
                if (TextUtils.hasContent(output)) {
                    this.context.printExact(output);
                }
                if (TextUtils.hasContent(error)) {
                    this.context.printExact(error);
                }
            } else if (this.asString(msg, UUID_DONE).equals(this.uuid)) {
                int exitCode = Integer.parseInt(String.valueOf(msg.get(RETURN_CODE)));
                this.result.set(new CustomSlcExitCode(exitCode));
                this.context.debugPrint("Recieved Exit Code: " + exitCode);
                this.completionLatch.countDown();
            } else if (!this.asString(msg, SHUTDOWN_CODE).isEmpty()) {
                this.context.print("WARNING: Server shutdown requested. This process will terminate.");
                this.result.compareAndSet(this.DEFAULT_RESULT, SlcExitCodes.SERVER_TERMINATION);
            }
        }
        catch (JSONException e) {
            this.context.printErr("Unexpected message from server: " + messageStr, e);
        }
    }

    private String asString(JSONObject msg, String key) {
        if (!msg.has(key)) {
            return "";
        }
        Object output = msg.get(key);
        if (output instanceof String) {
            return (String)output;
        }
        return String.valueOf(output);
    }

    private final class SocketCommsListener
    implements WebSocket.Listener {
        private StringBuilder text = new StringBuilder();

        private SocketCommsListener() {
        }

        @Override
        public void onError(WebSocket webSocket, Throwable e) {
            SocketCommunicationThread.this.context.printErr("Unexpected message from server", e);
            SocketCommunicationThread.this.result.compareAndSet(SocketCommunicationThread.this.DEFAULT_RESULT, SlcExitCodes.GENERAL_ERROR);
            SocketCommunicationThread.this.completionLatch.countDown();
        }

        @Override
        public CompletionStage<?> onClose(WebSocket webSocket, int statusCode, String reason) {
            SocketCommunicationThread.this.completionLatch.countDown();
            SocketCommunicationThread.this.context.debugPrint("Server connection closed with statusCode: " + statusCode + " - reason: " + reason);
            SocketCommunicationThread.this.context.debugPrint("Final text content: " + this.text);
            return null;
        }

        @Override
        public CompletionStage<?> onText(WebSocket webSocket, CharSequence data, boolean last) {
            this.text.append(data);
            if (last) {
                SocketCommunicationThread.this.processMessage(webSocket, this.text);
                this.text = new StringBuilder();
            }
            webSocket.request(1L);
            return null;
        }
    }
}

