/*
 * Decompiled with CFR 0.152.
 */
package slc.launcher.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.security.CodeSource;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import slc.launcher.context.SlcCliContext;
import slc.launcher.exception.NoDefinedInstallationLocationException;
import slc.launcher.utils.CustomSlcExitCode;
import slc.launcher.utils.ISlcExitCode;
import slc.launcher.utils.ISlcLogger;
import slc.launcher.utils.SlcExitCodes;

public final class ExecutionUtils {
    private static final ExecutorService outputRedirectionPool = Executors.newFixedThreadPool(2);

    private ExecutionUtils() {
    }

    public static Path defaultWorkingDirectory() {
        return Path.of("", new String[0]).toAbsolutePath();
    }

    public static ExecutionResults launchSlcProcess(SlcCliContext context, boolean detached, boolean returnResults, List<String> args2) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(args2).directory(context.workingDirectory().toFile());
        if (detached) {
            builder = builder.redirectOutput(ProcessBuilder.Redirect.DISCARD).redirectError(ProcessBuilder.Redirect.DISCARD);
        }
        context.debugPrint("Running: " + args2);
        context.debugPrint("This run is " + (detached ? "detached daemon" : "direct"));
        if (!detached && !returnResults) {
            builder.inheritIO();
        }
        Process process = builder.start();
        if (detached) {
            return new ExecutionResults(0);
        }
        List<Object> redirectionTasks = List.of();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ByteArrayOutputStream error = new ByteArrayOutputStream();
        if (returnResults) {
            redirectionTasks = List.of(outputRedirectionPool.submit(() -> ExecutionUtils.transferOutput(process.getInputStream(), output)), outputRedirectionPool.submit(() -> ExecutionUtils.transferOutput(process.getErrorStream(), error)));
        }
        try {
            int exitCode = process.waitFor();
            for (Future task : redirectionTasks) {
                task.get(5L, TimeUnit.SECONDS);
            }
            if (returnResults) {
                return new ExecutionResults(exitCode, ((Object)output).toString(), ((Object)error).toString());
            }
            return new ExecutionResults(exitCode);
        }
        catch (InterruptedException e) {
            context.debugPrint("Process launch was interrupted. Killing the process and exiting...");
            process.destroyForcibly();
        }
        catch (ExecutionException e) {
            context.debugPrint("Issue with input/output/error redirection tasks ability to complete: " + e.getLocalizedMessage(), e);
        }
        catch (TimeoutException e) {
            context.debugPrint("Timed out waiting for input/output/error redirection after process ended: " + e.getLocalizedMessage(), e);
        }
        return new ExecutionResults(SlcExitCodes.COMMAND_INTERRUPTED, "", "");
    }

    private static void transferOutput(InputStream input, OutputStream output) {
        try {
            input.transferTo(output);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Path executionHome(ISlcLogger logger) {
        Path home = null;
        try {
            home = ExecutionUtils.calculateInstallationDirectory();
        }
        catch (NoDefinedInstallationLocationException e) {
            home = ExecutionUtils.defaultWorkingDirectory();
            logger.log(ISlcLogger.SlcLogging.WARNING, "Falling back to working directory: " + home + " due to being unable to determine .jar home. " + e.getMessage(), e);
        }
        assert (home != null) : "Home should had been set in try or catch.";
        return home;
    }

    private static Path calculateInstallationDirectory() throws NoDefinedInstallationLocationException {
        try {
            CodeSource source2 = ExecutionUtils.class.getProtectionDomain().getCodeSource();
            if (source2 == null) {
                throw new NoDefinedInstallationLocationException("This launcher is not being run from a context where it has a defined installation location.");
            }
            return Path.of(source2.getLocation().toURI()).getParent();
        }
        catch (SecurityException e) {
            throw new NoDefinedInstallationLocationException("Cannot access information on installation location due to: " + e.getLocalizedMessage(), e);
        }
        catch (URISyntaxException e) {
            throw new NoDefinedInstallationLocationException("Unexpected URI translation error: " + e.getLocalizedMessage(), e);
        }
    }

    public static class ExecutionResults {
        public final ISlcExitCode exitCode;
        public final String output;
        public final String error;

        public ExecutionResults(ISlcExitCode exitCode, String output, String error) {
            this.exitCode = exitCode;
            this.output = output;
            this.error = error;
        }

        public String output() {
            return this.output;
        }

        public String error() {
            return this.error;
        }

        public ISlcExitCode exitCode() {
            return this.exitCode;
        }

        private ExecutionResults(int exitCode, String output, String error) {
            this.exitCode = new CustomSlcExitCode(exitCode);
            this.output = output;
            this.error = error;
        }

        private ExecutionResults(int exitCode) {
            this(exitCode, "", "");
        }
    }
}

