/*
 * Decompiled with CFR 0.152.
 */
package slc.launcher.utils;

import com.silabs.java.utils.ExceptionUtils;
import java.io.PrintStream;
import java.util.function.Supplier;
import slc.launcher.utils.ISlcLogger;

public class SlcDefaultLogger
implements ISlcLogger {
    private boolean debug;
    private static SlcDefaultLogger INSTANCE = new SlcDefaultLogger();

    public SlcDefaultLogger() {
    }

    private SlcDefaultLogger(boolean debug) {
        this.debug = debug;
    }

    public static SlcDefaultLogger instance() {
        return INSTANCE;
    }

    @Override
    public void updateDebug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public void daemonLog(Supplier<String> information) {
        this.log(ISlcLogger.SlcLogging.DEBUG, " - Launcher - " + information.get() + System.lineSeparator(), null);
    }

    @Override
    public void log(ISlcLogger.SlcLogging logLvl, String message, Throwable throwable) {
        PrintStream ps = this.loggerFor(logLvl);
        if (ps == null) {
            return;
        }
        ps.print(this.formatException(message, throwable));
    }

    private String formatException(String error, Throwable t) {
        if (t == null) {
            return error;
        }
        StringBuilder sb = new StringBuilder(error);
        sb.append(System.lineSeparator()).append(" - ").append(t.getMessage());
        if (this.debug) {
            sb.append(System.lineSeparator()).append(ExceptionUtils.exceptionToString(t));
        }
        return sb.toString();
    }

    private PrintStream loggerFor(ISlcLogger.SlcLogging logLvl) {
        switch (logLvl) {
            case ERROR: {
                return this.err();
            }
            case WARNING: 
            case OUTPUT: {
                return this.out();
            }
            case DEBUG: 
            case TRACE: {
                if (!this.debug) {
                    return null;
                }
                return this.out();
            }
        }
        return null;
    }

    @Override
    public PrintStream out() {
        return System.out;
    }

    @Override
    public PrintStream err() {
        return System.err;
    }

    @Override
    public SlcDefaultLogger copy() {
        return new SlcDefaultLogger(this.debug);
    }
}

