/*
 * Decompiled with CFR 0.152.
 */
package slc.launcher.utils;

import com.silabs.java.utils.HostUtils;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import slc.launcher.context.SlcCliContext;
import slc.launcher.utils.ExecutionUtils;
import slc.launcher.utils.SlcExitCodes;
import slc.launcher.utils.SlcLauncherException;

public final class VerifyJvm {
    private static final String JVM_VERSION_REGEX = "(version|openjdk)\\s*\"?\\s*(([0-9]+)\\.[0-9]+\\.[0-9]+)";
    private static final int MAJOR_VERSION_GROUP = 3;

    private VerifyJvm() {
    }

    public static void verifyJvm(SlcCliContext context, String jvmLoc, boolean isExternal) {
        if (context.args().noVerify) {
            return;
        }
        if (isExternal) {
            VerifyJvm.verifyExternalJvm(context, jvmLoc);
        } else if (!HostUtils.is64Bit()) {
            throw new SlcLauncherException("Current JVM is 32 bit. Slc requires a 64 bit JVM. Please use a different JVM or specify one using the '--java-location' arguement", SlcExitCodes.INVALID_SYSTEM_STATE);
        }
    }

    private static void verifyExternalJvm(SlcCliContext context, String jvmLoc) {
        try {
            ExecutionUtils.ExecutionResults results = ExecutionUtils.launchSlcProcess(context, false, true, List.of(jvmLoc, "--version"));
            String output = results.output.toLowerCase(Locale.getDefault()) + results.error.toLowerCase(Locale.getDefault());
            VerifyJvm.verifyExternalJvmBitness(context, jvmLoc, output);
            VerifyJvm.verifyExternalJvmVersion(context, jvmLoc, output);
        }
        catch (IOException e) {
            throw new SlcLauncherException("Failed to verify JVM at " + jvmLoc, SlcExitCodes.INVALID_SYSTEM_STATE);
        }
    }

    private static void verifyExternalJvmVersion(SlcCliContext context, String jvmLoc, String output) {
        Matcher matcher = Pattern.compile(JVM_VERSION_REGEX).matcher(output);
        if (!matcher.find()) {
            throw new SlcLauncherException("Failed to extract Java version from " + jvmLoc, SlcExitCodes.INVALID_SYSTEM_STATE);
        }
        String versionString = matcher.group(3);
        int jvmMajorVersion = Integer.parseInt(versionString);
        if (jvmMajorVersion < 11) {
            throw new SlcLauncherException("JVM version is too low. SLC requires a minimum of Java 11 for " + jvmLoc, SlcExitCodes.INVALID_SYSTEM_STATE);
        }
    }

    private static void verifyExternalJvmBitness(SlcCliContext context, String jvmLoc, String output) {
        if (!output.contains("64-bit")) {
            throw new SlcLauncherException("Selected JVM at '" + jvmLoc + "' is not 64 bit. Slc requires a 64 bit JVM.", SlcExitCodes.INVALID_SYSTEM_STATE);
        }
    }
}

