/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.IntFunction;

public class ArrayUtils {
    public static <T> boolean contains(T[] array, T obj) {
        if (array == null) {
            return false;
        }
        for (T e : array) {
            if ((e != null || obj != null) && (e == null || !e.equals(obj))) continue;
            return true;
        }
        return false;
    }

    public static <T> T[] copyAndAppend(T[] arr, T ent) {
        if (arr == null) {
            arr = (Object[])Array.newInstance(ent.getClass(), 1);
            arr[0] = ent;
            return arr;
        }
        T[] newArr = Arrays.copyOf(arr, arr.length + 1);
        newArr[arr.length] = ent;
        return newArr;
    }

    public static <T> T[] copyAndAppend(T[] arr, T[] ent) {
        if (arr == null) {
            if (ent == null) {
                return null;
            }
            return Arrays.copyOf(ent, ent.length);
        }
        if (ent == null) {
            return Arrays.copyOf(arr, arr.length);
        }
        T[] newArr = Arrays.copyOf(arr, arr.length + ent.length);
        System.arraycopy(ent, 0, newArr, arr.length, ent.length);
        return newArr;
    }

    public static <T> T firstOf(T[] arr) {
        return arr == null || arr.length == 0 ? null : (T)arr[0];
    }

    public static <T> IntFunction<T[]> toArray(Class<? extends T> klass) {
        return s -> (Object[])Array.newInstance(klass, s);
    }

    public static <T> T[] toArray(Class<? extends T> klass, Collection<?> els) {
        Object[] arr = (Object[])Array.newInstance(klass, els.size());
        return els.toArray(arr);
    }

    public static <T> T[] toArray(Class<? extends T> klass, Object ... els) {
        if (els != null) {
            Object[] arr = (Object[])Array.newInstance(klass, els.length);
            System.arraycopy(els, 0, arr, 0, els.length);
            return arr;
        }
        return null;
    }

    public static <T> T[] copyAndRemove(T[] arr, T ent) {
        if (arr == null) {
            return null;
        }
        for (int idx = 0; idx < arr.length; ++idx) {
            if (!ent.equals(arr[idx])) continue;
            T[] newArr = Arrays.copyOf(arr, arr.length - 1);
            System.arraycopy(arr, idx + 1, newArr, idx, arr.length - idx - 1);
            return newArr;
        }
        return arr;
    }

    public static <T> boolean isEmpty(T[] arr) {
        return arr == null || arr.length == 0;
    }
}

