/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils;

import java.util.Timer;
import java.util.TimerTask;

public class DeferredTaskRunner {
    private long timerInterval;
    private Timer timer;
    private Runnable runnableTask;
    private DeferredTask task;

    public DeferredTaskRunner(long interval, Runnable runnable2) {
        this.timerInterval = interval;
        this.runnableTask = runnable2;
        this.timer = new Timer();
        this.task = new DeferredTask(this.runnableTask);
    }

    public void restart() {
        this.cancel();
        this.timer.schedule((TimerTask)this.task, this.timerInterval);
    }

    public void restartImmediately() {
        this.cancel();
        this.timer.schedule((TimerTask)this.task, 1L);
    }

    public void cancel() {
        this.task.cancel();
        this.task = new DeferredTask(this.runnableTask);
    }

    private class DeferredTask
    extends TimerTask {
        private Runnable task;

        public DeferredTask(Runnable runnableTask) {
            this.task = runnableTask;
        }

        @Override
        public void run() {
            this.task.run();
        }
    }
}

