/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils;

import com.silabs.java.internal.utils.EitherImpl;
import java.util.function.Consumer;
import java.util.function.Function;

public interface Either<L, R> {
    public L left();

    public R right();

    public static <L, R> Either<L, R> ofLeft(L item) {
        return new EitherImpl<L, Object>(item, null);
    }

    public static <L, R> Either<L, R> ofRight(R item) {
        return new EitherImpl<Object, R>(null, item);
    }

    default public <T> T map(Function<L, T> leftFunction, Function<R, T> rightFunction) {
        return this.isLeft() ? leftFunction.apply(this.left()) : rightFunction.apply(this.right());
    }

    default public <T> void either(Consumer<L> leftConsumer, Consumer<R> rightConsumer) {
        if (this.isLeft()) {
            leftConsumer.accept(this.left());
        } else {
            rightConsumer.accept(this.right());
        }
    }

    default public boolean isLeft() {
        return this.left() != null;
    }

    public static <S> S reduce(Either<? extends S, ? extends S> either) {
        return either.isLeft() ? either.left() : either.right();
    }

    public static boolean equals(Either<?, ?> self, Object o) {
        if (self == o) {
            return true;
        }
        if (!(o instanceof Either)) {
            return false;
        }
        Either other = (Either)o;
        return other.isLeft() ? other.left().equals(self.left()) : other.right().equals(self.right());
    }

    public static int hashCode(Either<?, ?> self) {
        int result = 17;
        result += 31 * result + (self.isLeft() ? self.left().hashCode() : self.right().hashCode());
        return result;
    }

    public static String toString(Either<?, ?> self) {
        return self.isLeft() ? "Left with " + self.left() : "Right with " + self.right();
    }
}

