/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils;

import com.silabs.java.utils.HostUtils;
import com.silabs.java.utils.IFileVisitor;
import com.silabs.java.utils.LangUtilities;
import com.silabs.java.utils.TextUtils;
import com.silabs.java.utils.log.Log;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class FileUtils {
    private static final ConcurrentHashMap<Object, ?> syncMap = new ConcurrentHashMap(128, 0.5f, 64);

    private FileUtils() {
    }

    public static Charset defaultCharset() {
        return StandardCharsets.UTF_8;
    }

    public static Path resolve(Path workingDirectory, String path) {
        String convertedPath = FileUtils.fixPathIfApplicable(path);
        Path cliPath = FileUtils.createCliFile(convertedPath).toPath();
        if (workingDirectory == null) {
            return cliPath;
        }
        return workingDirectory.resolve(cliPath);
    }

    private static String fixPathIfApplicable(String path) {
        if (FileUtils.needsFixup(path)) {
            char driveLetter = path.charAt(1);
            return Character.toUpperCase(driveLetter) + ":\\" + (path.length() > 3 ? path.substring(3) : "");
        }
        return path;
    }

    private static boolean needsFixup(String path) {
        if (!HostUtils.isWindows() || !path.startsWith("/")) {
            return false;
        }
        if (path.length() == 2) {
            return true;
        }
        return path.length() > 2 && path.charAt(2) == '/';
    }

    public static Optional<Path> tryRelativise(Path first, Path second) {
        if (first.isAbsolute() && second.isAbsolute() && Objects.equals(first.getRoot(), second.getRoot())) {
            return Optional.of(first.relativize(second));
        }
        return Optional.empty();
    }

    public static File createCliFile(String path) {
        return FileUtils.createCliFile(path, HostUtils.userHome());
    }

    private static File createCliFile(String path, String userHome) {
        if (path == null) {
            return new File("");
        }
        if ("~".equals(path)) {
            return new File(userHome);
        }
        if (path.startsWith("~/") || HostUtils.isWindows() && path.startsWith("~\\")) {
            return new File(userHome, path.substring(2));
        }
        return new File(path);
    }

    public static String getUniqueFileName(File fileDir, String fileName, String ... otherNewFiles) {
        return FileUtils.getUniqueFileName(fileName, null, fileDir, otherNewFiles);
    }

    public static String getUniqueFileName(String fileName, String fileExtension, File fileDir, String ... otherNewFiles) {
        HashSet<String> fileSet = new HashSet<String>();
        FileUtils.fillSetWithFiles(fileSet, fileDir, otherNewFiles);
        return FileUtils.doGetUniqueFileName(fileName, fileExtension, fileSet);
    }

    public static void fillSetWithFiles(Set<String> fileSet, File fileDir, String ... otherNewFiles) {
        String[] dirFiles;
        if (otherNewFiles != null) {
            for (String otherProj : otherNewFiles) {
                fileSet.add(otherProj.toLowerCase(Locale.ROOT));
            }
        }
        if (fileDir != null && (dirFiles = fileDir.list()) != null) {
            for (String file : dirFiles) {
                fileSet.add(file.toLowerCase(Locale.ROOT));
            }
        }
    }

    public static String getUniqueFileName(String fileName, Set<String> fileSet) {
        return FileUtils.doGetUniqueFileName(fileName, null, fileSet);
    }

    @Deprecated
    public static String doGetUniqueFileName(String fileName, Set<String> fileSet) {
        return FileUtils.getUniqueFileName(fileName, fileSet);
    }

    private static String doGetUniqueFileName(String fileName, String fileExtension, Set<String> fileSet) {
        return FileUtils.doGetUniqueFileName(fileName, fileExtension, "_", "", fileSet);
    }

    public static String getUniqueFileName(String fileName, String beginStr, String endStr, Set<String> fileSet) {
        return FileUtils.doGetUniqueFileName(fileName, null, beginStr, endStr, fileSet);
    }

    private static String doGetUniqueFileName(String fileName, String fileExtension, String beg, String end, Set<String> fileSetInput) {
        if (fileExtension == null) {
            fileExtension = "";
        }
        if (!((String)fileExtension).isEmpty() && !((String)fileExtension).contains(".")) {
            fileExtension = "." + (String)fileExtension;
        }
        if (fileSetInput == null || fileSetInput.isEmpty() || fileName == null) {
            return fileName + (String)fileExtension;
        }
        Set fileSet = fileSetInput.stream().map(s -> s.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
        if (fileSet.contains((fileName + (String)fileExtension).toLowerCase(Locale.ROOT))) {
            for (int unique = 2; unique <= 100; ++unique) {
                StringBuilder sb = new StringBuilder(fileName).append(beg).append(unique).append(end).append((String)fileExtension);
                String newProjName = sb.toString();
                if (fileSet.contains(newProjName.toLowerCase(Locale.ROOT))) continue;
                return newProjName;
            }
        }
        return fileName + (String)fileExtension;
    }

    public static Collection<File> findMatchingFiles(File contentRoot, String glob, int depth) throws IOException {
        return FileUtils.findMatchingFiles(contentRoot, depth, glob);
    }

    public static Collection<File> findMatchingFiles(File contentRoot, int depth, String ... globs) throws IOException {
        final ArrayList<File> matchedFiles = new ArrayList<File>();
        final List matchers = Stream.of(globs).map(glob -> FileSystems.getDefault().getPathMatcher("glob:**/" + glob)).collect(Collectors.toList());
        Files.walkFileTree(contentRoot.toPath(), EnumSet.noneOf(FileVisitOption.class), depth, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (matchers.stream().anyMatch(matcher -> matcher.matches(file))) {
                    matchedFiles.add(file.toFile());
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
        return matchedFiles;
    }

    public static char[] readFileContents(File file, String encoding) throws IOException {
        try (BufferedInputStream fis = new BufferedInputStream(new FileInputStream(file));){
            char[] cArray = FileUtils.readInputStreamContentsAndClose(fis, encoding);
            return cArray;
        }
    }

    public static String readFileContents(Path file, Charset encoding) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(file, FileUtils.encoding(encoding));){
            char[] results = FileUtils.readReaderContentsAndClose(reader);
            String string = String.valueOf(results);
            return string;
        }
    }

    public static char[] readInputStreamContentsAndClose(InputStream is, String encoding) throws IOException {
        try (Reader reader = FileUtils.createInputStreamReader(is, encoding);){
            char[] cArray = FileUtils.readReaderContentsAndClose(reader);
            return cArray;
        }
    }

    public static char[] readReaderContentsAndClose(Reader reader) throws IOException {
        int len;
        char[] buf = new char[1024];
        StringBuffer sb = new StringBuffer();
        while ((len = reader.read(buf)) > 0) {
            sb.append(buf, 0, len);
        }
        reader.close();
        return sb.toString().toCharArray();
    }

    public static void writeFileContents(Path path, String contents, Charset charset) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(path, FileUtils.encoding(charset), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
            writer.write(contents);
        }
    }

    public static void writeFileContents(File file, String text) throws IOException {
        FileUtils.writeFileContents(file, text.toCharArray(), null);
    }

    public static void writeFileContents(File file, char[] text, String encoding) throws IOException {
        FileUtils.writeOutputStreamContentsAndClose(new FileOutputStream(file), text, encoding);
    }

    public static void writeLines(File file, Collection<String> content) throws IOException {
        FileUtils.writeLines(file, content, FileUtils.defaultCharset());
    }

    public static void writeLines(File file, Collection<String> content, Charset encoding) throws IOException {
        try (PrintWriter pw = new PrintWriter(file, encoding);){
            for (String s : content) {
                pw.println(s);
            }
        }
    }

    public static void appendLinesToFile(File file, Collection<String> content) throws IOException {
        try (FileWriter fw = new FileWriter(file, true);
             BufferedWriter bw = new BufferedWriter(fw);
             PrintWriter pw = new PrintWriter(bw);){
            content.forEach(pw::println);
        }
    }

    public static void writeOutputStreamContentsAndClose(OutputStream os, char[] text, String encoding) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(os, FileUtils.encoding(encoding));
        FileUtils.writeWriterContentsAndClose(writer, text);
    }

    public static void writeWriterContentsAndClose(Writer writer, char[] text) throws IOException {
        try {
            writer.write(text, 0, text.length);
            writer.flush();
        }
        finally {
            writer.close();
        }
    }

    public static File[] listFilesInTree(File dir, boolean recordDirectories, FileFilter filter) {
        ArrayList<File> files = new ArrayList<File>();
        FileUtils.listFilesInTreeHelper(files, dir, filter, recordDirectories);
        return files.toArray(new File[files.size()]);
    }

    private static void listFilesInTreeHelper(List<File> files, File dir, FileFilter filter, boolean recordDirectories) {
        File[] allEntries;
        if (recordDirectories) {
            files.add(dir);
        }
        if ((allEntries = dir.listFiles()) == null) {
            return;
        }
        for (File fileOrDir : allEntries) {
            if (fileOrDir.getName().equals(".") || fileOrDir.getName().equals("..")) continue;
            if (fileOrDir.isDirectory()) {
                if (filter != null && !filter.accept(fileOrDir)) continue;
                FileUtils.listFilesInTreeHelper(files, fileOrDir, filter, recordDirectories);
                continue;
            }
            if (filter != null && !filter.accept(fileOrDir)) continue;
            files.add(fileOrDir);
        }
    }

    public static void copyFile(File from, File to) throws IOException {
        try {
            syncMap.compute(to, (k, v) -> {
                try {
                    if (to.exists() && !to.canWrite() && HostUtils.isWindows()) {
                        Files.setAttribute(to.toPath(), "dos:readonly", false, new LinkOption[0]);
                    }
                    Files.copy(from.toPath(), to.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES, LinkOption.NOFOLLOW_LINKS);
                    try {
                        Files.setLastModifiedTime(to.toPath(), FileTime.from(Instant.now()));
                    }
                    catch (IOException iOException) {}
                }
                catch (IOException ioe) {
                    throw new UncheckedIOException(ioe);
                }
                return null;
            });
        }
        catch (UncheckedIOException re) {
            throw re.getCause();
        }
    }

    public static String normaliseAsString(Path p) {
        return p.toAbsolutePath().normalize().toString();
    }

    public static void copyFile(InputStream in, File to) throws IOException {
        try (FileOutputStream out = new FileOutputStream(to);){
            int len;
            byte[] buffer = new byte[4096];
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
        }
        in.close();
    }

    public static void copyTree(File from, File to, FileFilter filter) throws IOException {
        String fromPath;
        String toPath;
        if (!from.exists()) {
            throw new IOException("Source of copy '" + from.getName() + "' doesn't exist");
        }
        try {
            toPath = to.getCanonicalPath();
            fromPath = from.getCanonicalPath();
        }
        catch (IOException e) {
            throw new IOException("Failed to copy " + from.getAbsolutePath(), e);
        }
        if (Objects.equals(toPath, fromPath)) {
            throw new IOException("'" + from.getName() + "' cannot copy to itself");
        }
        if (from.isDirectory() && !Files.isSymbolicLink(from.toPath())) {
            File[] children = from.listFiles(filter);
            to.mkdirs();
            for (File kid : children) {
                File curto = new File(to, kid.getName());
                FileUtils.copyTree(kid, curto, filter);
            }
        } else {
            FileUtils.copyFile(from, to);
        }
    }

    public static void copyTreeNoParent(File from, File to, FileFilter filter) throws IOException {
        if (!from.isDirectory()) {
            throw new IOException("Source is not a directory");
        }
        File[] files = from.listFiles(filter);
        to.mkdirs();
        for (File file : files) {
            File curto = new File(to, file.getName());
            if (file.isDirectory()) {
                FileUtils.copyTree(file, curto, filter);
                continue;
            }
            FileUtils.copyFile(file, curto);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void accept(File dir, IFileVisitor visitor) {
        if (visitor.enterDirectory(dir)) {
            try {
                File[] ents = dir.listFiles();
                if (ents == null) {
                    return;
                }
                for (File ent : ents) {
                    if (ent.isDirectory()) {
                        FileUtils.accept(ent, visitor);
                        continue;
                    }
                    visitor.visitFile(ent);
                }
            }
            finally {
                visitor.exitDirectory(dir);
            }
        }
    }

    public static void deleteDirectoryContents(File dir) throws IOException {
        FileUtils.deleteDirectoryContents(dir, 500, 3);
    }

    private static void deleteDirectoryContents(File dir, int timeout2, int retries) throws IOException {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isDirectory()) continue;
                FileUtils.deleteDirectoryAndContents(file, timeout2, retries);
            }
        }
        if ((files = dir.listFiles()) != null) {
            for (File file : files) {
                if (file.delete()) continue;
                throw new IOException("Failed to delete " + file.getAbsolutePath());
            }
        }
    }

    public static void deleteDirectoryAndContents(File dir) throws IOException {
        FileUtils.deleteDirectoryAndContents(dir, 500, 3);
    }

    private static void deleteDirectoryAndContents(File dir, int timeout2, int retries) throws IOException {
        int retryCount = 0;
        while (true) {
            try {
                FileUtils.deleteDirectoryContents(dir, 50, 0);
                if (dir.exists() && !dir.delete()) {
                    throw new IOException("Failed to delete " + dir.getAbsolutePath());
                }
            }
            catch (IOException e) {
                if (++retryCount >= retries) {
                    throw e;
                }
                LangUtilities.sleepSafely(timeout2);
                continue;
            }
            break;
        }
    }

    public static File stripExtension(File file) {
        if (file == null) {
            return null;
        }
        String newName = FileUtils.stripExtension(file.getName());
        return new File(file.getParentFile(), newName);
    }

    public static String stripExtension(String fileName) {
        int pos;
        String result = fileName;
        if (fileName != null && (pos = fileName.lastIndexOf(46)) >= 1) {
            result = fileName.substring(0, pos);
        }
        return result;
    }

    public static String getExtension(File file) {
        if (file == null) {
            return null;
        }
        return FileUtils.getExtension(file.getName());
    }

    public static String getExtension(String fileName) {
        int pos;
        String result = null;
        if (fileName != null && (pos = fileName.lastIndexOf(46)) >= 0) {
            result = fileName.substring(pos + 1);
        }
        return result;
    }

    public static String getLastPathSegment(File fullPath) {
        if (fullPath != null) {
            return fullPath.getName();
        }
        return null;
    }

    public static File addLastPathSegment(File fullPath, String pathSegment) {
        if (fullPath != null && pathSegment != null) {
            return new File(fullPath, pathSegment);
        }
        return fullPath;
    }

    public static File replaceFileExtension(File fullPath, String extension) {
        if (fullPath == null) {
            return fullPath;
        }
        File updated = FileUtils.removeFileExtension(fullPath);
        return FileUtils.addFileExtension(updated, extension);
    }

    public static File addFileExtension(File fullPath, String extension) {
        if (fullPath != null && extension != null) {
            return new File(fullPath.getParentFile(), fullPath.getName() + "." + extension);
        }
        return fullPath;
    }

    public static File removeFileExtension(File fullPath) {
        String name;
        int index;
        if (fullPath != null && (index = (name = fullPath.getName()).lastIndexOf(46)) > 0) {
            name = name.substring(0, index);
            return new File(fullPath.getParentFile(), name);
        }
        return fullPath;
    }

    public static long getFileSize(File file) {
        long sz = 0L;
        if (file != null && file.exists()) {
            try (Stream<Path> fileStream = Files.walk(file.toPath(), new FileVisitOption[0]);){
                sz = fileStream.mapToLong(p -> p.toFile().length()).sum();
            }
            catch (IOException e) {
                Log.error("Could not calculate file size, " + file.getPath(), e);
            }
        }
        return sz;
    }

    public static File fileFromUrl(URL url) {
        File f = null;
        try {
            f = new File(url.toURI());
        }
        catch (Exception e) {
            f = new File(url.getPath());
        }
        return f;
    }

    public static List<String> readLines(File f) throws IOException {
        return FileUtils.readLines(f, Charset.defaultCharset());
    }

    public static List<String> readLines(File f, Charset encoding) throws IOException {
        try (FileInputStream is = new FileInputStream(f);){
            List<String> list = FileUtils.readLines(is, encoding);
            return list;
        }
    }

    public static List<String> readLines(InputStream is) throws IOException {
        return FileUtils.readLines(is, Charset.defaultCharset());
    }

    public static List<String> readLines(InputStream is, Charset encoding) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(FileUtils.createInputStreamReader(is, encoding));
        String line = null;
        while ((line = reader.readLine()) != null) {
            lines.add(line);
        }
        return lines;
    }

    public static boolean fileExists(String s) {
        if (s == null) {
            return false;
        }
        try {
            File f = new File(s);
            if (f.exists()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isChildDirectory(File parent, File dir) {
        if (parent == null) {
            return false;
        }
        parent = parent.getAbsoluteFile();
        dir = dir.getAbsoluteFile();
        do {
            if (!dir.equals(parent)) continue;
            return true;
        } while ((dir = dir.getParentFile()) != null);
        return false;
    }

    public static boolean isValidDirectory(String path) {
        if (!TextUtils.isBlank(path)) {
            File file = new File(path);
            return file.isDirectory();
        }
        return false;
    }

    private static List<String> getPathList(File f) {
        ArrayList<String> l = new ArrayList<String>();
        if (f == null) {
            return l;
        }
        try {
            for (File r = f.getCanonicalFile(); r != null; r = r.getParentFile()) {
                l.add(r.getName());
            }
        }
        catch (IOException e) {
            Log.warning("Cannot get path list from file: " + f, e);
            l = null;
        }
        return l;
    }

    public static String matchPathLists(List<String> r, List<String> f, String filePathSeparator) {
        int j;
        if (filePathSeparator == null) {
            filePathSeparator = File.separator;
        }
        Object s = "";
        int i = r.size() - 1;
        for (j = f.size() - 1; i >= 0 && j >= 0 && r.get(i).equals(f.get(j)); --i, --j) {
        }
        while (i >= 0) {
            s = (String)s + ".." + filePathSeparator;
            --i;
        }
        while (j >= 1) {
            s = (String)s + f.get(j) + filePathSeparator;
            --j;
        }
        if (j > -1) {
            s = (String)s + f.get(j);
        }
        if (((String)s).endsWith(filePathSeparator)) {
            s = ((String)s).substring(0, ((String)s).length() - filePathSeparator.length());
        }
        if (((String)s).isEmpty()) {
            s = ".";
        }
        return s;
    }

    public static String getRelativePath(File home, File f) {
        return FileUtils.matchPathLists(FileUtils.getPathList(home), FileUtils.getPathList(f), null);
    }

    public static String getRelativePath(File home, File f, String filePathSeparator) {
        return FileUtils.matchPathLists(FileUtils.getPathList(home), FileUtils.getPathList(f), filePathSeparator);
    }

    private static Map<String, String> readKeyValueMap(LineNumberReader reader) throws IOException {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        FileUtils.readKeyValueInput(reader, map::put);
        return map;
    }

    private static List<String[]> readKeyValueList(LineNumberReader reader) throws IOException {
        ArrayList<String[]> list = new ArrayList<String[]>();
        FileUtils.readKeyValueInput(reader, (k, v) -> list.add(new String[]{k, v}));
        return list;
    }

    private static void readKeyValueInput(LineNumberReader reader, BiConsumer<String, String> cons) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            String[] keyValue;
            if (line.startsWith("#") || line.length() == 0 || (keyValue = TextUtils.readKeyValue(line)) == null) continue;
            cons.accept(keyValue[0], TextUtils.escapeValue(keyValue[1]));
        }
    }

    public static Map<String, String> readKeyValueMap(File propertyFile) throws IOException {
        try (LineNumberReader reader = new LineNumberReader(FileUtils.createInputStreamReader((InputStream)new FileInputStream(propertyFile), FileUtils.defaultCharset()));){
            Map<String, String> map = FileUtils.readKeyValueMap(reader);
            return map;
        }
    }

    public static Map<String, String> readKeyValueMap(URL propertyFile) throws IOException {
        try (LineNumberReader reader = new LineNumberReader(FileUtils.createInputStreamReader(propertyFile.openStream(), FileUtils.defaultCharset()));){
            Map<String, String> map = FileUtils.readKeyValueMap(reader);
            return map;
        }
    }

    public static List<String[]> readKeyValueList(URL propertyFile) throws IOException {
        try (LineNumberReader reader = new LineNumberReader(FileUtils.createInputStreamReader(propertyFile.openStream(), FileUtils.defaultCharset()));){
            List<String[]> list = FileUtils.readKeyValueList(reader);
            return list;
        }
    }

    private static Reader createInputStreamReader(InputStream is, String encoding) throws UnsupportedEncodingException {
        return FileUtils.createInputStreamReader(is, FileUtils.encoding(encoding));
    }

    private static Reader createInputStreamReader(InputStream is, Charset encoding) throws UnsupportedEncodingException {
        return new InputStreamReader(is, FileUtils.encoding(encoding));
    }

    private static Charset encoding(Charset encoding) {
        return encoding == null ? FileUtils.defaultCharset() : encoding;
    }

    private static Charset encoding(String encoding) {
        return encoding == null ? FileUtils.defaultCharset() : Charset.forName(encoding);
    }

    public static Properties readProperties(File file) throws IOException {
        if (file.exists() && file.canRead()) {
            Properties p = new Properties();
            try (FileInputStream is = new FileInputStream(file);){
                p.load(is);
                Properties properties = p;
                return properties;
            }
        }
        throw new FileNotFoundException(file.getAbsolutePath());
    }

    public static void writeProperties(Properties p, File file) throws IOException {
        if (file.exists() && file.canRead()) {
            try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));){
                p.store(os, "");
            }
        } else {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
    }

    public static File locate(List<File> paths, String name) {
        for (File p : paths) {
            File x = new File(p, name);
            if (!x.exists()) continue;
            return x;
        }
        return null;
    }

    public static File locate(File directory, String[] names) {
        for (String n : names) {
            File f = new File(directory, n);
            if (!f.exists()) continue;
            return f;
        }
        return null;
    }

    public static boolean matchesGlob(File f, String glob) {
        Path matchingPath;
        Object actualGlobUsed;
        if (HostUtils.isWindows()) {
            actualGlobUsed = glob.contains("\\") ? glob.replaceAll(Pattern.quote("\\"), "/") : glob;
            String s = f.getAbsolutePath().replaceAll(Pattern.quote("\\"), "/");
            matchingPath = Paths.get(s, new String[0]);
        } else {
            actualGlobUsed = glob;
            matchingPath = f.toPath();
        }
        if (!((String)actualGlobUsed).startsWith("glob:")) {
            actualGlobUsed = "glob:" + (String)actualGlobUsed;
        }
        PathMatcher pm = FileSystems.getDefault().getPathMatcher((String)actualGlobUsed);
        return pm.matches(matchingPath);
    }

    public static void setExecutable(File f) {
        if (!f.canExecute() && !f.setExecutable(true)) {
            Log.warning("Failed to set file as executable: " + f.getAbsolutePath());
        }
    }

    public static Path toPathNullable(File target) {
        if (target == null) {
            return null;
        }
        return target.toPath();
    }

    public static boolean isSameFile(Path first, Path second) {
        if (first == null || second == null) {
            return false;
        }
        try {
            return Files.isSameFile(first, second);
        }
        catch (IOException e) {
            Path cleanedFirst = first.normalize();
            Path cleanedSecond = second.normalize();
            return cleanedFirst.equals(cleanedSecond);
        }
    }
}

