/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils;

import com.silabs.java.utils.LangUtilities;
import com.silabs.java.utils.TextUtils;
import java.util.Locale;

public enum SystemSettings {
    DEVICE_SCAN_DISABLE("STUDIO_DEVICE_SCAN_DISABLE", "studio.deviceScanDisable", false),
    WINE_LOCATION("STUDIO_WINE_LOCATION", "studio.wineLocation", null),
    RUN_LONG_UNIT_TESTS("RUN_LONG_UNIT_TESTS", "studio.runLongUnitTests", false),
    DISABLE_STUDIO_DATA_CACHING("DISABLE_STUDIO_DATA_CACHING", "studio.disableDataCaching", false),
    DISABLE_UC_SLCC_CACHE("DISABLE_UC_SLCC_CACHE", "studio.uc.disable_slcc_cache", false),
    MAKE_LOCATION("STUDIO_MAKE_LOCATION", "studio.makeLocation", ""),
    DISABLE_LEGACY_STACKS("DISABLE_LEGACY_STACKS", "studio.disableLegacyStacks", false),
    SI_APACK_LOCATION("SI_APACK_LOCK_DIR", "studio.siApackLockDir", "~/.si_apack"),
    ADAPTER_PACK_PATH("STUDIO_ADAPTER_PACK_PATH", "studio.adapterPackPath", ""),
    ADAPTER_PACK_LOG("STUDIO_ADAPTER_PACK_LOG", "studio.adapterPackLog", ""),
    FAKE_PROPERTIES_PATH_ALLOWED("FAKE_PROPERTIES_PATH_ALLOWED", "studio.fakePropertiesPathAllowed", false),
    DISABLE_REPO_MANAGEMENT("DISABLE_REPO_MANAGEMENT", "studio.disableRepoManagement", false);

    private final String environmentVariable;
    private final String javaSystemProperty;
    private final Object defaultValue;
    private Object internalValue;

    private SystemSettings(String environmentVariable, String javaSystemProperty, Object defaultValue) {
        this.environmentVariable = environmentVariable;
        this.javaSystemProperty = javaSystemProperty;
        this.defaultValue = defaultValue;
    }

    private String valueFromEnvironment() {
        return SystemSettings.valueFromEnvironment(this.javaSystemProperty, this.environmentVariable);
    }

    public String environmentVariable() {
        return this.environmentVariable;
    }

    public String javaProperty() {
        return this.javaSystemProperty;
    }

    public String describe() {
        String env = null;
        String prop = null;
        if (this.javaSystemProperty != null) {
            prop = "java system property '" + this.javaSystemProperty + "'";
        }
        if (this.environmentVariable != null) {
            env = "environment variable '" + this.environmentVariable + "'";
        }
        if (prop != null && env != null) {
            return prop + " or " + env;
        }
        if (prop != null) {
            return prop;
        }
        if (env != null) {
            return env;
        }
        return "";
    }

    public void set(Object value) {
        this.internalValue = value;
    }

    public boolean isSet() {
        Object value = this.doGetValue();
        return LangUtilities.parseBoolean(value);
    }

    public String value() {
        Object value = this.doGetValue();
        if (value instanceof String) {
            return (String)value;
        }
        return TextUtils.print(value);
    }

    private Object doGetValue() {
        String value = this.valueFromEnvironment();
        if (value != null) {
            return value;
        }
        if (this.internalValue != null) {
            return this.internalValue;
        }
        return this.defaultValue;
    }

    private static String valueFromEnvironment(String javaProperty, String envVariable) {
        String value = null;
        if (javaProperty != null) {
            value = System.getProperty(javaProperty);
        }
        if (value == null && envVariable != null) {
            value = System.getenv(envVariable);
        }
        return value;
    }

    public static String apackEnginePathOverride(String engine) {
        String envName;
        if (engine == null) {
            return engine;
        }
        String propName = "studio.adapterPackEngine" + TextUtils.titleCase(engine);
        String override = SystemSettings.valueFromEnvironment(propName, envName = "STUDIO_ADAPTER_PACK_ENGINE_" + engine.toUpperCase(Locale.ROOT));
        if (override != null) {
            return override;
        }
        return engine;
    }
}

