/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils;

import com.silabs.java.utils.FileUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public final class TemporaryFile
implements AutoCloseable {
    private Path tempFile;

    public static TemporaryFile directory(String prefix) throws IOException {
        return new TemporaryFile(Files.createTempDirectory(prefix, new FileAttribute[0]));
    }

    public static TemporaryFile file(String prefix, String suffix) throws IOException {
        return new TemporaryFile(Files.createTempFile(prefix, suffix, new FileAttribute[0]));
    }

    public static TemporaryFile existing(Path tempFile) {
        return new TemporaryFile(tempFile);
    }

    private TemporaryFile(Path tempFile) {
        this.tempFile = tempFile;
    }

    public Path path() {
        return this.tempFile;
    }

    public String toString() {
        return this.path().toString();
    }

    @Override
    public void close() throws IOException {
        FileUtils.deleteDirectoryAndContents(this.tempFile.toFile());
    }
}

