/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils.preferences;

import com.silabs.java.utils.preferences.IPreferences;

public interface IUserPreference {
    public IPreferences preferenceStore();

    public String name();

    public int defaultIntValue();

    public String defaultStringValue();

    public boolean defaultBoolValue();

    public Type type();

    default public String key() {
        return this.getClass() + "." + this.name();
    }

    default public void intSet(int value) {
        this.preferenceStore().putInt(this.key(), value);
    }

    default public int intValue() {
        return this.preferenceStore().getInt(this.key(), this.defaultIntValue());
    }

    default public void boolSet(boolean value) {
        this.preferenceStore().putBoolean(this.key(), value);
    }

    default public boolean boolValue() {
        return this.preferenceStore().getBoolean(this.key(), this.defaultBoolValue());
    }

    default public void stringSet(String value) {
        this.preferenceStore().put(this.key(), value);
    }

    default public String stringValue() {
        return this.preferenceStore().get(this.key(), this.defaultStringValue());
    }

    public static enum Type {
        INT,
        BOOL,
        RGB,
        STRING,
        FONT;

    }
}

