/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils.preferences;

import com.silabs.java.utils.preferences.ITypeReference;
import com.silabs.java.utils.preferences.ITypedPropertyLookup;
import com.silabs.java.utils.preferences.PropertyGroupReference;
import java.util.Objects;

public class PropertyReference<T> {
    private final String key;
    private final PropertyGroupReference group;
    private final ITypeReference<T> type;
    private final String defaultValue;

    public static <T, E extends PropertyReference<T>> PropertyReference<T> create(ITypeReference<T> type, String key) {
        return new PropertyReference<Object>(type, key, null, null);
    }

    public static <T, E extends PropertyReference<T>> PropertyReference<T> create(ITypeReference<T> type, String key, PropertyGroupReference group) {
        return new PropertyReference<Object>(type, key, group, null);
    }

    public static <T, E extends PropertyReference<T>> PropertyReference<T> create(ITypeReference<T> type, String key, T defaultValue) {
        return new PropertyReference<T>(type, key, null, defaultValue);
    }

    private PropertyReference(ITypeReference<T> type, String propId, PropertyGroupReference group, T defaultValue) {
        this.type = type;
        this.key = propId;
        this.group = group;
        this.defaultValue = defaultValue == null ? null : type.stringize(defaultValue);
    }

    protected PropertyReference(ITypeReference<T> type, String propId, T defaultValue) {
        this(type, propId, null, defaultValue);
    }

    public T get(ITypedPropertyLookup lookup) {
        return lookup.getProperty(this);
    }

    public String id() {
        return this.key;
    }

    public String resolvedId() {
        String groupStr = this.group == null ? "" : this.group.groupId() + ".";
        return groupStr + this.key;
    }

    public PropertyGroupReference group() {
        return this.group;
    }

    public ITypeReference<T> type() {
        return this.type;
    }

    public String getDefault() {
        return this.defaultValue;
    }

    public int hashCode() {
        return Objects.hash(this.key, this.type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PropertyReference)) {
            return false;
        }
        PropertyReference other = (PropertyReference)obj;
        if (!Objects.equals(this.key, other.key)) {
            return false;
        }
        return Objects.equals(this.type, other.type);
    }

    public String toString() {
        return this.resolvedId();
    }
}

