/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils.zip.impl;

import com.silabs.java.utils.zip.ICompressionAlgorithm;
import com.silabs.java.utils.zip.impl.ZipCompressionAlgorithm;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;

public class CompressionUtils {
    private static final List<Supplier<ICompressionAlgorithm>> defaultAlgorithms = List.of(ZipCompressionAlgorithm::new);
    private static Set<ICompressionAlgorithm> cachedAlgorithms;

    public static ICompressionAlgorithm create(URL url) throws IOException {
        return CompressionUtils.algorithms().stream().filter(a -> a.isValid(url)).findFirst().orElseGet(ZipCompressionAlgorithm::new);
    }

    private static Collection<ICompressionAlgorithm> algorithms() {
        Set<ICompressionAlgorithm> lclCachedAlgorithms = cachedAlgorithms;
        if (lclCachedAlgorithms == null) {
            lclCachedAlgorithms = new HashSet<ICompressionAlgorithm>();
            defaultAlgorithms.stream().map(Supplier::get).forEach(lclCachedAlgorithms::add);
            cachedAlgorithms = lclCachedAlgorithms;
        }
        return lclCachedAlgorithms;
    }
}

