/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.java.utils.zip.impl;

import com.silabs.java.utils.zip.ICompressionAlgorithm;
import com.silabs.java.utils.zip.ICompressionEntry;
import com.silabs.java.utils.zip.ICompressionInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class ZipCompressionAlgorithm
implements ICompressionAlgorithm {
    @Override
    public boolean isValid(URL zipUrl) {
        String urlStr = zipUrl.toString();
        return urlStr.contains("zip");
    }

    @Override
    public ICompressionInputStream open(URL zipUrl) throws IOException {
        return new ZipCompressionInputStream(zipUrl);
    }

    private class ZipCompressionInputStream
    implements ICompressionInputStream,
    AutoCloseable {
        private final ZipInputStream zipIs;

        protected ZipCompressionInputStream(URL url) throws IOException {
            this.zipIs = new ZipInputStream(url.openStream());
        }

        @Override
        public int read(byte[] buff) throws IOException {
            return this.zipIs.read(buff);
        }

        @Override
        public void closeEntry() throws IOException {
            this.zipIs.closeEntry();
        }

        @Override
        public ICompressionEntry getNextEntry() throws IOException {
            ZipEntry entry = this.zipIs.getNextEntry();
            return entry == null ? null : new ZipCompressionEntry(entry);
        }

        @Override
        public void close() throws IOException {
            this.zipIs.close();
        }
    }

    private class ZipCompressionEntry
    implements ICompressionEntry {
        private final ZipEntry zipEntry;

        protected ZipCompressionEntry(ZipEntry zipEntry) {
            this.zipEntry = zipEntry;
        }

        @Override
        public String getName() {
            return this.zipEntry.getName();
        }

        @Override
        public boolean isDirectory() {
            return this.zipEntry.isDirectory();
        }

        @Override
        public boolean isLink() {
            return false;
        }

        @Override
        public int getMode() {
            byte[] extra = this.zipEntry.getExtra();
            if (extra != null && extra.length > 0) {
                return this.zipEntry.getExtra()[0];
            }
            return 0;
        }
    }
}

