/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.metrics.MeterBuilder;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerBuilder;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.sdk.OpenTelemetrySdkBuilder;
import io.opentelemetry.sdk.logs.SdkLoggerProvider;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OpenTelemetrySdk
implements OpenTelemetry {
    private final ObfuscatedTracerProvider tracerProvider;
    private final ObfuscatedMeterProvider meterProvider;
    private final SdkLoggerProvider loggerProvider;
    private final ContextPropagators propagators;

    OpenTelemetrySdk(SdkTracerProvider tracerProvider, SdkMeterProvider meterProvider, SdkLoggerProvider loggerProvider, ContextPropagators propagators) {
        this.tracerProvider = new ObfuscatedTracerProvider(tracerProvider);
        this.meterProvider = new ObfuscatedMeterProvider(meterProvider);
        this.loggerProvider = loggerProvider;
        this.propagators = propagators;
    }

    public static OpenTelemetrySdkBuilder builder() {
        return new OpenTelemetrySdkBuilder();
    }

    @Override
    public TracerProvider getTracerProvider() {
        return this.tracerProvider;
    }

    public SdkTracerProvider getSdkTracerProvider() {
        return this.tracerProvider.unobfuscate();
    }

    @Override
    public MeterProvider getMeterProvider() {
        return this.meterProvider;
    }

    public SdkMeterProvider getSdkMeterProvider() {
        return this.meterProvider.unobfuscate();
    }

    public SdkLoggerProvider getSdkLoggerProvider() {
        return this.loggerProvider;
    }

    @Override
    public ContextPropagators getPropagators() {
        return this.propagators;
    }

    public String toString() {
        return "OpenTelemetrySdk{tracerProvider=" + this.tracerProvider.unobfuscate() + ", meterProvider=" + this.meterProvider.unobfuscate() + ", loggerProvider=" + this.loggerProvider + ", propagators=" + this.propagators + "}";
    }

    @ThreadSafe
    static class ObfuscatedTracerProvider
    implements TracerProvider {
        private final SdkTracerProvider delegate;

        ObfuscatedTracerProvider(SdkTracerProvider delegate) {
            this.delegate = delegate;
        }

        @Override
        public Tracer get(String instrumentationScopeName) {
            return this.delegate.get(instrumentationScopeName);
        }

        @Override
        public Tracer get(String instrumentationScopeName, String instrumentationScopeVersion) {
            return this.delegate.get(instrumentationScopeName, instrumentationScopeVersion);
        }

        @Override
        public TracerBuilder tracerBuilder(String instrumentationScopeName) {
            return this.delegate.tracerBuilder(instrumentationScopeName);
        }

        public SdkTracerProvider unobfuscate() {
            return this.delegate;
        }
    }

    @ThreadSafe
    static class ObfuscatedMeterProvider
    implements MeterProvider {
        private final SdkMeterProvider delegate;

        ObfuscatedMeterProvider(SdkMeterProvider delegate) {
            this.delegate = delegate;
        }

        @Override
        public MeterBuilder meterBuilder(String instrumentationScopeName) {
            return this.delegate.meterBuilder(instrumentationScopeName);
        }

        public SdkMeterProvider unobfuscate() {
            return this.delegate;
        }
    }
}

