/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.DoubleHistogramBuilder;
import io.opentelemetry.api.metrics.LongHistogramBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.internal.ThrottlingLogger;
import io.opentelemetry.sdk.metrics.AbstractInstrument;
import io.opentelemetry.sdk.metrics.AbstractInstrumentBuilder;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.InstrumentValueType;
import io.opentelemetry.sdk.metrics.SdkLongHistogram;
import io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.internal.instrument.BoundDoubleHistogram;
import io.opentelemetry.sdk.metrics.internal.state.BoundStorageHandle;
import io.opentelemetry.sdk.metrics.internal.state.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.internal.state.MeterSharedState;
import io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;
import java.util.logging.Level;
import java.util.logging.Logger;

final class SdkDoubleHistogram
extends AbstractInstrument
implements DoubleHistogram {
    private static final Logger logger = Logger.getLogger(SdkDoubleHistogram.class.getName());
    private final ThrottlingLogger throttlingLogger = new ThrottlingLogger(logger);
    private final WriteableMetricStorage storage;

    private SdkDoubleHistogram(InstrumentDescriptor descriptor, WriteableMetricStorage storage) {
        super(descriptor);
        this.storage = storage;
    }

    @Override
    public void record(double value, Attributes attributes, Context context) {
        if (value < 0.0) {
            this.throttlingLogger.log(Level.WARNING, "Histograms can only record non-negative values. Instrument " + this.getDescriptor().getName() + " has recorded a negative value.");
            return;
        }
        this.storage.recordDouble(value, attributes, context);
    }

    @Override
    public void record(double value, Attributes attributes) {
        this.record(value, attributes, Context.current());
    }

    @Override
    public void record(double value) {
        this.record(value, Attributes.empty());
    }

    BoundDoubleHistogram bind(Attributes attributes) {
        return new BoundInstrument(this.getDescriptor(), this.storage.bind(attributes), attributes);
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }

    static final class BoundInstrument
    implements BoundDoubleHistogram {
        private final ThrottlingLogger throttlingLogger = new ThrottlingLogger(SdkDoubleHistogram.access$000());
        private final InstrumentDescriptor descriptor;
        private final BoundStorageHandle aggregatorHandle;
        private final Attributes attributes;

        BoundInstrument(InstrumentDescriptor descriptor, BoundStorageHandle handle, Attributes attributes) {
            this.descriptor = descriptor;
            this.aggregatorHandle = handle;
            this.attributes = attributes;
        }

        @Override
        public void record(double value, Context context) {
            if (value < 0.0) {
                this.throttlingLogger.log(Level.WARNING, "Histograms can only record non-negative values. Instrument " + this.descriptor.getName() + " has recorded a negative value.");
                return;
            }
            this.aggregatorHandle.recordDouble(value, this.attributes, context);
        }

        @Override
        public void record(double value) {
            this.record(value, Context.current());
        }

        @Override
        public void unbind() {
            this.aggregatorHandle.release();
        }
    }

    static final class SdkDoubleHistogramBuilder
    extends AbstractInstrumentBuilder<SdkDoubleHistogramBuilder>
    implements DoubleHistogramBuilder {
        SdkDoubleHistogramBuilder(MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, String name) {
            super(meterProviderSharedState, meterSharedState, InstrumentType.HISTOGRAM, InstrumentValueType.DOUBLE, name, "", "");
        }

        @Override
        protected SdkDoubleHistogramBuilder getThis() {
            return this;
        }

        @Override
        public SdkDoubleHistogram build() {
            return this.buildSynchronousInstrument((x$0, x$1) -> new SdkDoubleHistogram((InstrumentDescriptor)x$0, (WriteableMetricStorage)x$1));
        }

        @Override
        public LongHistogramBuilder ofLongs() {
            return this.swapBuilder(SdkLongHistogram.SdkLongHistogramBuilder::new);
        }
    }
}

