/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.LongHistogram;
import io.opentelemetry.api.metrics.LongHistogramBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.internal.ThrottlingLogger;
import io.opentelemetry.sdk.metrics.AbstractInstrument;
import io.opentelemetry.sdk.metrics.AbstractInstrumentBuilder;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.InstrumentValueType;
import io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.internal.instrument.BoundLongHistogram;
import io.opentelemetry.sdk.metrics.internal.state.BoundStorageHandle;
import io.opentelemetry.sdk.metrics.internal.state.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.internal.state.MeterSharedState;
import io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;
import java.util.logging.Level;
import java.util.logging.Logger;

final class SdkLongHistogram
extends AbstractInstrument
implements LongHistogram {
    private static final Logger logger = Logger.getLogger(SdkLongHistogram.class.getName());
    private final ThrottlingLogger throttlingLogger = new ThrottlingLogger(logger);
    private final WriteableMetricStorage storage;

    private SdkLongHistogram(InstrumentDescriptor descriptor, WriteableMetricStorage storage) {
        super(descriptor);
        this.storage = storage;
    }

    @Override
    public void record(long value, Attributes attributes, Context context) {
        if (value < 0L) {
            this.throttlingLogger.log(Level.WARNING, "Histograms can only record non-negative values. Instrument " + this.getDescriptor().getName() + " has recorded a negative value.");
            return;
        }
        this.storage.recordLong(value, attributes, context);
    }

    @Override
    public void record(long value, Attributes attributes) {
        this.record(value, attributes, Context.current());
    }

    @Override
    public void record(long value) {
        this.record(value, Attributes.empty());
    }

    BoundLongHistogram bind(Attributes attributes) {
        return new BoundInstrument(this.getDescriptor(), this.storage.bind(attributes), attributes);
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }

    static final class BoundInstrument
    implements BoundLongHistogram {
        private final ThrottlingLogger throttlingLogger = new ThrottlingLogger(SdkLongHistogram.access$000());
        private final InstrumentDescriptor descriptor;
        private final BoundStorageHandle handle;
        private final Attributes attributes;

        BoundInstrument(InstrumentDescriptor descriptor, BoundStorageHandle handle, Attributes attributes) {
            this.descriptor = descriptor;
            this.handle = handle;
            this.attributes = attributes;
        }

        @Override
        public void record(long value, Context context) {
            if (value < 0L) {
                this.throttlingLogger.log(Level.WARNING, "Histograms can only record non-negative values. Instrument " + this.descriptor.getName() + " has recorded a negative value.");
                return;
            }
            this.handle.recordLong(value, this.attributes, context);
        }

        @Override
        public void record(long value) {
            this.record(value, Context.current());
        }

        @Override
        public void unbind() {
            this.handle.release();
        }
    }

    static final class SdkLongHistogramBuilder
    extends AbstractInstrumentBuilder<SdkLongHistogramBuilder>
    implements LongHistogramBuilder {
        SdkLongHistogramBuilder(MeterProviderSharedState meterProviderSharedState, MeterSharedState sharedState, String name, String description, String unit) {
            super(meterProviderSharedState, sharedState, InstrumentType.HISTOGRAM, InstrumentValueType.LONG, name, description, unit);
        }

        @Override
        protected SdkLongHistogramBuilder getThis() {
            return this;
        }

        @Override
        public SdkLongHistogram build() {
            return this.buildSynchronousInstrument((x$0, x$1) -> new SdkLongHistogram((InstrumentDescriptor)x$0, (WriteableMetricStorage)x$1));
        }
    }
}

