/***************************************************************************//**
 * @file
 * @brief app_humidity_temp_cli_cmds.c
 *******************************************************************************
 * # License
 * <b>Copyright 2018 Silicon Laboratories Inc. www.silabs.com</b>
 *******************************************************************************
 *
 * The licensor of this software is Silicon Laboratories Inc. Your use of this
 * software is governed by the terms of Silicon Labs Master Software License
 * Agreement (MSLA) available at
 * www.silabs.com/about-us/legal/master-software-license-agreement. This
 * software is distributed to you in Source Code format and is governed by the
 * sections of the MSLA applicable to Source Code.
 *
 ******************************************************************************/

#include <stdint.h>
#include "sl_cli.h"
#include "sl_cli_arguments.h"
#include "sl_cli_handles.h"

extern uint32_t rhData;
extern int32_t tempData;

void app_humidity_temp_get_temp(sl_cli_command_arg_t *arguments)
{
  char *str = ((char *)arguments->argv[2]);
  float temp_celcius = tempData / 1000;
  float temp = temp_celcius;

  if ((*str == 'f') || (*str == 'F')) {
    temp = (temp * (9.0 / 5.0)) + 32.0;
  }

  printf("Temperature: %0.2f %s\n", temp, str);
}

void app_humidity_temp_get_humidity(sl_cli_command_arg_t *arguments)
{
  float humidity = (rhData / 1000);
  (void)arguments;
  printf("Relative Humidity: %0.2f %%\n", humidity);
}

void app_humidity_temp_get_values(sl_cli_command_arg_t *arguments)
{
  char *str = ((char *)arguments->argv[2]);
  float humidity = (rhData / 1000);
  float temp_celcius = tempData / 1000;
  float temp = temp_celcius;

  if ((*str == 'f') || (*str == 'F')) {
    temp = (temp * (9.0 / 5.0)) + 32.0;
  }

  printf("Relative Humidity: %0.2f %%\n", humidity);
  printf("Temperature: %0.2f %s\n", temp, str);
}
