/***************************************************************************//**
 * @file
 * @brief app_adc_cli_cmds.c
 *******************************************************************************
 * # License
 * <b>Copyright 2018 Silicon Laboratories Inc. www.silabs.com</b>
 *******************************************************************************
 *
 * The licensor of this software is Silicon Laboratories Inc. Your use of this
 * software is governed by the terms of Silicon Labs Master Software License
 * Agreement (MSLA) available at
 * www.silabs.com/about-us/legal/master-software-license-agreement. This
 * software is distributed to you in Source Code format and is governed by the
 * sections of the MSLA applicable to Source Code.
 *
 ******************************************************************************/

#include <stdint.h>
#include "sl_cli.h"
#include "sl_cli_arguments.h"
#include "sl_cli_handles.h"

extern uint32_t adcData;

void app_adc_get_raw(sl_cli_command_arg_t *arguments)
{
  (void)arguments;
  printf("ADC Raw Value: 0x%lx \n", adcData);
}

void app_adc_get_voltage(sl_cli_command_arg_t *arguments)
{
  float millivolts = (adcData * 2500) / 4096;
  (void)arguments;
  printf("ADC Voltage: %0.2f mV\n", millivolts);
}

void app_adc_get_values(sl_cli_command_arg_t *arguments)
{
  float millivolts = (adcData * 2500) / 4096;
  (void)arguments;
  printf("ADC Raw Value: 0x%lx \n", adcData);
  printf("ADC Voltage: %0.2f mV\n", millivolts);
}
