/***************************************************************************//**
 * @file
 * @brief ADC peripheral example demo header
 *******************************************************************************
 * # License
 * <b>Copyright 2020 Silicon Laboratories Inc. www.silabs.com</b>
 *******************************************************************************
 *
 * SPDX-License-Identifier: Zlib
 *
 * The licensor of this software is Silicon Laboratories Inc.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software. If you use this software
 *    in a product, an acknowledgment in the product documentation would be
 *    appreciated but is not required.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 *
 *******************************************************************************
 * # Evaluation Quality
 * This code has been minimally tested to ensure that it builds and is suitable
 * as a demonstration for evaluation purposes only. This code will be maintained
 * at the sole discretion of Silicon Labs.
 ******************************************************************************/

#ifndef SL_APP_ADC_H
#define SL_APP_ADC_H

#include <stdint.h>
#include "sl_status.h"

/**************************************************************************//**
 * Initialize Relative Humidity and Temperature sensor.
 *****************************************************************************/
void sl_adc_init(void);

/**************************************************************************//**
 * Deinitialize Relative Humidity and Temperature sensor.
 *****************************************************************************/
void sl_adc_deinit(void);

void sl_adc_start_measurement(void);

/**************************************************************************//**
 * Getter for Relative Humidity and Temperature sensor measurement data.
 * @param[out] rh Relative humidity (in 0.001 percent).
 * @param[out] t Temperature (in 0.001 Celsius).
 * @return Status of the operation.
 *****************************************************************************/
void sl_adc_measurement_get(uint32_t *adcData);

#endif // SL_APP_ADC_H
