/***************************************************************************//**
 * @file sl_cli_command_table.c
 * @brief Declarations of relevant command structs for cli framework.
 * @version x.y.z
 *******************************************************************************
 * # License
 * <b>Copyright 2018 Silicon Laboratories Inc. www.silabs.com</b>
 *******************************************************************************
 *
 * SPDX-License-Identifier: Zlib
 *
 * The licensor of this software is Silicon Laboratories Inc.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software. If you use this software
 *    in a product, an acknowledgment in the product documentation would be
 *    appreciated but is not required.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 *
 ******************************************************************************/

#include <stdlib.h>

#include "sl_cli_config.h"
#include "sl_cli_command.h"
#include "sl_cli_arguments.h"

#ifdef __cplusplus
extern "C" {
#endif

// Provide function declarations
void app_humidity_temp_get_temp(sl_cli_command_arg_t *arguments);
void app_humidity_temp_get_humidity(sl_cli_command_arg_t *arguments);
void app_humidity_temp_get_values(sl_cli_command_arg_t *arguments);

void app_adc_get_raw(sl_cli_command_arg_t *arguments);
void app_adc_get_voltage(sl_cli_command_arg_t *arguments);
void app_adc_get_values(sl_cli_command_arg_t *arguments);

// Command structs. Names are in the format : cli_cmd_{command group name}_{command name}
// In order to support hyphen in command and group name, every occurence of it while
// building struct names will be replaced by "_hyphen_"
static const sl_cli_command_info_t cli_cmd_sensor_temp = \
  SL_CLI_COMMAND(app_humidity_temp_get_temp,
                 "Get sensor temperature value",
                  "temperature unit (C or F)" SL_CLI_UNIT_SEPARATOR,
                 {SL_CLI_ARG_STRING, SL_CLI_ARG_END, });

static const sl_cli_command_info_t cli_cmd_sensor_humidity = \
  SL_CLI_COMMAND(app_humidity_temp_get_humidity,
                 "Get sensor humidity value",
                  "",
                 {SL_CLI_ARG_END, });

static const sl_cli_command_info_t cli_cmd_sensor_all = \
  SL_CLI_COMMAND(app_humidity_temp_get_values,
                 "Get sensor values",
                  "temperature unit (C or F)" SL_CLI_UNIT_SEPARATOR,
                 {SL_CLI_ARG_STRING, SL_CLI_ARG_END, });

static const sl_cli_command_info_t cli_cmd_adc_raw = \
  SL_CLI_COMMAND(app_adc_get_raw,
                 "Get ADC raw conversion",
                  "",
                 {SL_CLI_ARG_END, });

static const sl_cli_command_info_t cli_cmd_adc_voltage = \
  SL_CLI_COMMAND(app_adc_get_voltage,
                 "Get ADC measurement voltage",
                  "",
                 {SL_CLI_ARG_END, });

static const sl_cli_command_info_t cli_cmd_adc_all = \
  SL_CLI_COMMAND(app_adc_get_values,
                 "Get ADC values",
                  "",
                 {SL_CLI_ARG_END, });

// Create group command tables and structs if cli_groups given
// in template. Group name is suffixed with _group_table for tables
// and group commands are cli_cmd_( group name )_group
static const sl_cli_command_entry_t sensor_group_table[] = {
  { "temp", &cli_cmd_sensor_temp, false },
  { "humidity", &cli_cmd_sensor_humidity, false },
  { "all", &cli_cmd_sensor_all, false },
  { NULL, NULL, false },
};
static const sl_cli_command_info_t cli_cmd_sensor_group = \
  SL_CLI_COMMAND_GROUP(sensor_group_table, "");

static const sl_cli_command_entry_t adc_group_table[] = {
  { "raw", &cli_cmd_adc_raw, false },
  { "voltage", &cli_cmd_adc_voltage, false },
  { "all", &cli_cmd_adc_all, false },
  { NULL, NULL, false },
};
static const sl_cli_command_info_t cli_cmd_adc_group = \
  SL_CLI_COMMAND_GROUP(adc_group_table, "");

// Create root command table
const sl_cli_command_entry_t app_cli_command_table[] = {
  { "adc", &cli_cmd_adc_group, false },
  { "sensor", &cli_cmd_sensor_group, false },
  { NULL, NULL, false },
};

#ifdef __cplusplus
}
#endif
